<?php
session_start();
require_once '../includes/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header("Location: ../auth/login.php");
    exit;
}

$stmt = $pdo->query("SELECT * FROM sites ORDER BY created_at DESC");
$sites = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <title>Manage Sites | CFS System OS</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- AdminLTE & Plugins -->
  <link rel="stylesheet" href="../assets/plugins/fontawesome-free/css/all.min.css">
  <link rel="stylesheet" href="../assets/adminlte/css/adminlte.min.css">
  <link rel="stylesheet" href="../assets/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css">
  <link rel="stylesheet" href="../assets/plugins/datatables-responsive/css/responsive.bootstrap4.min.css">
  <link rel="stylesheet" href="../assets/plugins/toastr/toastr.min.css">

  <style>
    .modal-header {
      background-color: #007bff;
      color: white;
    }
  </style>
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<div class="wrapper">

  <?php include '../includes/topbar.php'; ?>
  <?php include '../includes/sidebar.php'; ?>

  <div class="content-wrapper">
    <div class="content-header">
      <div class="container-fluid d-flex justify-content-between align-items-center">
        <h4 class="mb-0">🏢 Manage Sites</h4>
        <button class="btn btn-primary" data-toggle="modal" data-target="#addSiteModal">
          <i class="fas fa-plus-circle"></i> Add New Site
        </button>
      </div>
    </div>

    <div class="content">
      <div class="container-fluid">

        <div class="card">
          <div class="card-header bg-primary text-white">
            <h5 class="card-title">All Sites</h5>
          </div>
          <div class="card-body">
            <table id="siteTable" class="table table-bordered table-hover">
              <thead>
                <tr>
                  <th>#</th>
                  <th>Site Name</th>
                  <th>Location</th>
                  <th>Status</th>
                  <th>Created</th>
                  <th>Actions</th>
                </tr>
              </thead>
              <tbody>
              <?php $i = 1; foreach ($sites as $site): ?>
                <tr>
                  <td><?= $i++ ?></td>
                  <td><?= htmlspecialchars($site['site_name']) ?></td>
                  <td><?= htmlspecialchars($site['location']) ?></td>
                  <td>
                    <span class="badge <?= $site['status'] === 'active' ? 'badge-success' : 'badge-secondary' ?>">
                      <?= ucfirst($site['status']) ?>
                    </span>
                  </td>
                  <td><?= date('d M Y', strtotime($site['created_at'])) ?></td>
                  <td>
                    <button class="btn btn-sm btn-warning" data-toggle="modal" data-target="#editSiteModal<?= $site['id'] ?>"><i class="fas fa-edit"></i></button>
                    <a href="delete_site.php?id=<?= $site['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this site?')"><i class="fas fa-trash"></i></a>
                  </td>
                </tr>

                <!-- Edit Modal -->
                <div class="modal fade" id="editSiteModal<?= $site['id'] ?>" tabindex="-1">
                  <div class="modal-dialog">
                    <form action="update_site.php" method="POST" class="modal-content">
                      <div class="modal-header">
                        <h5 class="modal-title">Edit Site</h5>
                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                      </div>
                      <div class="modal-body">
                        <input type="hidden" name="id" value="<?= $site['id'] ?>">
                        <div class="form-group">
                          <label>Site Name</label>
                          <input type="text" name="site_name" class="form-control" value="<?= htmlspecialchars($site['site_name']) ?>" required>
                        </div>
                        <div class="form-group">
                          <label>Location</label>
                          <input type="text" name="location" class="form-control" value="<?= htmlspecialchars($site['location']) ?>" required>
                        </div>
                        <div class="form-group">
                          <label>Status</label>
                          <select name="status" class="form-control">
                            <option value="active" <?= $site['status'] === 'active' ? 'selected' : '' ?>>Active</option>
                            <option value="inactive" <?= $site['status'] === 'inactive' ? 'selected' : '' ?>>Inactive</option>
                          </select>
                        </div>
                      </div>
                      <div class="modal-footer">
                        <button class="btn btn-primary" type="submit">Save Changes</button>
                        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                      </div>
                    </form>
                  </div>
                </div>
              <?php endforeach; ?>
              </tbody>
            </table>
          </div>
        </div>

      </div>
    </div>
  </div>

  <!-- Add Site Modal -->
  <div class="modal fade" id="addSiteModal" tabindex="-1">
    <div class="modal-dialog">
      <form action="add_site.php" method="POST" class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Add New Site</h5>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>
        <div class="modal-body">
          <div class="form-group">
            <label>Site Name</label>
            <input type="text" name="site_name" class="form-control" required>
          </div>
          <div class="form-group">
            <label>Location</label>
            <input type="text" name="location" class="form-control" required>
          </div>
          <div class="form-group">
            <label>Status</label>
            <select name="status" class="form-control">
              <option value="active">Active</option>
              <option value="inactive">Inactive</option>
            </select>
          </div>
        </div>
        <div class="modal-footer">
          <button class="btn btn-success" type="submit">Add Site</button>
          <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
        </div>
      </form>
    </div>
  </div>

  <!-- Toast (Optional Notification) -->
  <div class="position-fixed bottom-0 end-0 p-3" style="z-index: 1055">
    <div id="siteToast" class="toast bg-success text-white" role="alert" data-delay="3000">
      <div class="toast-header bg-success text-white">
        <strong class="me-auto">Sites</strong>
        <small>just now</small>
        <button type="button" class="ml-2 mb-1 close btn-close-white" data-dismiss="toast"></button>
      </div>
      <div class="toast-body">
        ✅ Site management loaded successfully.
      </div>
    </div>
  </div>

</div>

<!-- Scripts -->
<script src="../assets/plugins/jquery/jquery.min.js"></script>
<script src="../assets/plugins/bootstrap/js/bootstrap.bundle.min.js"></script>
<script src="../assets/plugins/datatables/jquery.dataTables.min.js"></script>
<script src="../assets/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js"></script>
<script src="../assets/plugins/datatables-responsive/js/dataTables.responsive.min.js"></script>
<script src="../assets/plugins/toastr/toastr.min.js"></script>
<script src="../assets/adminlte/js/adminlte.min.js"></script>

<script>
  $(function () {
    $('#siteTable').DataTable({
      responsive: true,
      autoWidth: false
    });

    const toast = new bootstrap.Toast(document.getElementById('siteToast'));
    toast.show();
  });
</script>
</body>
</html>
